import com.phidgets.*;
import com.phidgets.event.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class VehicleController extends JFrame implements ActionListener {
	private InterfaceKitPhidget interfaceKit;
	private VehicleView	view;
	private VehicleModel model;
	private int pressure= 0;
	private int pressureIndex= 1;
	private int rotation= 0;
	private int rotationIndex= 2;
	private Timer tick;
	public static final int WIDTH= 800;
	public static final int HEIGHT= 800;

	public static void main(String[] args) {
		VehicleController vc = new VehicleController();
		vc.pack();
		vc.setVisible(true);
		vc.openIntfcKit();
	}

	public VehicleController() {
		model= new VehicleModel(this, WIDTH, HEIGHT);
		view = new VehicleView(model, WIDTH, HEIGHT);
		Container c= getContentPane();
		c.add(view, BorderLayout.CENTER);
		addWindowListener(new WindowAdapter() {
			public void windowClosing(WindowEvent we) {
				closeIntfcKit();
			}
		});
		// Complete this code
	}

	private void openIntfcKit() {
		try {
			interfaceKit = new InterfaceKitPhidget();
			interfaceKit.addErrorListener(new ErrorListener() {
				public void error(ErrorEvent ee) {
					System.out.println("Error event for " + ee);
				}
			});
			interfaceKit.addSensorChangeListener(new SensorChangeListener() {
				public void sensorChanged(SensorChangeEvent se) {
					// Complete this code
				}
			});
			interfaceKit.openAny();
			interfaceKit.waitForAttachment();
			interfaceKit.setRatiometric(true);
			while (!interfaceKit.getRatiometric());
		} catch (PhidgetException pe) {
			System.err.println(pe);
		}
	}
	
	public int getPressure() { return pressure; }
	public int getRotation() { return rotation; }
	
	public void actionPerformed( ActionEvent e ) {
		// Complete this code
	}

	private void closeIntfcKit() {
		System.out.println("Closing...");
		try { 
			interfaceKit.close(); }
		catch (PhidgetException pe) { 
			System.err.println(pe); }
		interfaceKit = null;
		System.exit(0);
	}
}